/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaTitlePane;
import de.javasoft.plaf.synthetica.painter.RootPanePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainter;
import de.javasoft.util.OS;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;

public class SyntheticaRootPaneUI
extends BasicRootPaneUI {
    private Window window;
    private JRootPane rootPane;
    private LayoutManager layoutManager;
    private LayoutManager oldLayoutManager;
    private MouseInputListener mouseInputListener;
    private WindowListener windowListener;
    private ComponentListener windowShapeResizeListener;
    private ComponentListener windowMenuBarResizeListener;
    private JComponent titlePane;
    private Insets resizeInsets;
    public static final boolean EVAL_COPY = false;
    public static final int EVAL_HEIGHT = 16;
    public static final String EVAL_TEXT = "Synthetica - Unregistered Evaluation Copy!";

    public static ComponentUI createUI(JComponent c2) {
        return new SyntheticaRootPaneUI();
    }

    public static final boolean isEvalCopy() {
        return false;
    }

    public void installUI(JComponent c2) {
        super.installUI(c2);
        this.rootPane = (JRootPane)c2;
        if (this.isDecorated(this.rootPane)) {
            this.installClientDecorations(this.rootPane);
        }
    }

    public void uninstallUI(JComponent c2) {
        super.uninstallUI(c2);
        this.uninstallClientDecorations(this.rootPane);
        this.rootPane = null;
    }

    private void installClientDecorations(JRootPane root) {
        SyntheticaTitlePane titlePane = new SyntheticaTitlePane(root, this);
        this.setTitlePane(root, titlePane);
        this.installBorder(root);
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        if (this.window instanceof Dialog && SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.dialogStyle.enabled", this.window, false) && SyntheticaLookAndFeel.getClientProperty("Synthetica.style", this.rootPane, null) == null) {
            String styleName = SyntheticaLookAndFeel.getString("Synthetica.rootPane.dialogStyle.defaultName", this.window, "Dialog");
            this.rootPane.putClientProperty("Synthetica.style", styleName);
            Container contentPane = this.rootPane.getContentPane();
            if (contentPane == null || contentPane.getName().startsWith("null.")) {
                // empty if block
            }
            contentPane.setName(styleName + ".contentPane");
        } else if (this.window instanceof Frame && SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.frameStyle.enabled", this.window, false) && SyntheticaLookAndFeel.getClientProperty("Synthetica.style", this.rootPane, null) == null) {
            String styleName = SyntheticaLookAndFeel.getString("Synthetica.rootPane.frameStyle.defaultName", this.window, "Frame");
            this.rootPane.putClientProperty("Synthetica.style", styleName);
            Container contentPane = this.rootPane.getContentPane();
            if (contentPane == null || contentPane.getName().startsWith("null.")) {
                // empty if block
            }
            contentPane.setName(styleName + ".contentPane");
        }
    }

    private void uninstallClientDecorations(JRootPane root) {
        if (this.titlePane != null && this.titlePane instanceof SyntheticaTitlePane) {
            ((SyntheticaTitlePane)this.titlePane).uninstallListeners(root);
        }
        this.setTitlePane(root, null);
        this.uninstallBorder(root);
        this.uninstallWindowListeners(root);
        this.uninstallLayout(root);
    }

    public JComponent getTitlePane() {
        return this.titlePane;
    }

    void installBorder(JRootPane root) {
        if (this.isDecorated(root)) {
            root.setBorder(new Border(){

                public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h2) {
                    SynthContext sc = SyntheticaLookAndFeel.createContext((JComponent)c2, Region.ROOT_PANE, 0);
                    SyntheticaPainter.getInstance().paintRootPaneBorder(sc, g2, x, y, w, h2);
                }

                public Insets getBorderInsets(Component c2) {
                    if (SyntheticaRootPaneUI.this.window instanceof Frame && (((Frame)SyntheticaRootPaneUI.this.window).getExtendedState() & 6) == 6) {
                        return new Insets(0, 0, 0, 0);
                    }
                    Insets insets = SyntheticaRootPaneUI.this.getDefaultBorderInsets();
                    if (SyntheticaRootPaneUI.this.getRootPaneBorderText() != null) {
                        insets = (Insets)insets.clone();
                        insets.bottom += 16;
                        insets.left += SyntheticaLookAndFeel.getInt("Synthetica.rootPane.margin.left", SyntheticaRootPaneUI.this.window, 0);
                    }
                    return insets;
                }

                public boolean isBorderOpaque() {
                    return false;
                }
            });
        }
    }

    private Insets getDefaultBorderInsets() {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.border.size", this.window);
        if (insets == null) {
            insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.border.insets", this.window);
        }
        return insets;
    }

    public String getRootPaneBorderText() {
        return SyntheticaLookAndFeel.getString("Synthetica.rootPane.borderText", this.window);
    }

    private void uninstallBorder(JRootPane root) {
        root.setBorder(null);
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        this.resizeInsets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.resizeInsets", (Component)this.window, this.getDefaultBorderInsets());
        if (this.window != null) {
            if (this.getMouseInputListener() == null) {
                this.setMouseInputListener(new MouseInputHandler());
            }
            if (this.windowListener == null) {
                if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(this.window)) {
                    if (OS.getCurrentOS() == OS.Mac) {
                        SyntheticaLookAndFeel.setWindowOpaque(this.window, false);
                    } else {
                        try {
                            SyntheticaLookAndFeel.setWindowOpaque(this.window, false);
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                }
                boolean opaque = SyntheticaLookAndFeel.getBoolean("Synthetica.window.contentPane.opaque", this.window, true);
                this.setContentPaneOpaque(this.window, opaque);
                this.windowListener = new WindowAdapter(){

                    public void windowOpened(WindowEvent evt) {
                        Window w = evt.getWindow();
                        if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(SyntheticaRootPaneUI.this.window)) {
                            SyntheticaLookAndFeel.setWindowOpaque(w, false);
                            if (SyntheticaLookAndFeel.getBoolean("Synthetica.window.contentPane.opaque", SyntheticaRootPaneUI.this.window, true)) {
                                SyntheticaRootPaneUI.this.setContentPaneOpaque(w, true);
                            }
                        }
                    }

                    public void windowDeactivated(WindowEvent e2) {
                        if (SyntheticaRootPaneUI.this.mouseInputListener instanceof MouseInputHandler) {
                            ((MouseInputHandler)SyntheticaRootPaneUI.this.mouseInputListener).cancelDragResize();
                        }
                    }
                };
                this.window.addWindowListener(this.windowListener);
            }
            if (SyntheticaLookAndFeel.isWindowShapeEnabled(this.window)) {
                if (this.windowShapeResizeListener == null && SyntheticaLookAndFeel.isWindowShapeSupported(this.window)) {
                    this.windowShapeResizeListener = new ComponentAdapter(){

                        public void componentResized(ComponentEvent evt) {
                            Window w = (Window)evt.getComponent();
                            SyntheticaLookAndFeel.updateWindowShape(w);
                        }
                    };
                    this.window.addComponentListener(this.windowShapeResizeListener);
                } else if (OS.getCurrentOS() == OS.Mac) {
                    SyntheticaLookAndFeel.updateWindowShape(this.window);
                }
            }
            if (this.titlePane instanceof SyntheticaTitlePane && ((SyntheticaTitlePane)this.titlePane).showMenuBarInTitlePane() && this.windowMenuBarResizeListener == null) {
                this.windowMenuBarResizeListener = new ComponentAdapter(){

                    public void componentResized(ComponentEvent evt) {
                        SyntheticaRootPaneUI.this.rootPane.doLayout();
                    }
                };
                this.window.addComponentListener(this.windowMenuBarResizeListener);
            }
        }
    }

    private void setContentPaneOpaque(Window w, boolean opaque) {
        if (w instanceof JDialog && ((JDialog)w).getContentPane() instanceof JComponent) {
            ((JComponent)((JDialog)w).getContentPane()).setOpaque(opaque);
        } else if (w instanceof JFrame && ((JFrame)w).getContentPane() instanceof JComponent) {
            ((JComponent)((JFrame)w).getContentPane()).setOpaque(opaque);
        } else if (w instanceof JWindow && ((JWindow)w).getContentPane() instanceof JComponent) {
            ((JComponent)((JWindow)w).getContentPane()).setOpaque(opaque);
        }
    }

    private void uninstallWindowListeners(JRootPane root) {
        if (this.window != null) {
            if (this.mouseInputListener instanceof MouseInputHandler) {
                this.window.removeMouseListener(this.mouseInputListener);
                this.window.removeMouseMotionListener(this.mouseInputListener);
            }
            this.window.removeWindowListener(this.windowListener);
            this.window.removeComponentListener(this.windowShapeResizeListener);
            this.window.removeComponentListener(this.windowMenuBarResizeListener);
        }
        if (this.mouseInputListener instanceof MouseInputHandler) {
            this.mouseInputListener = null;
        }
        this.windowListener = null;
        this.windowShapeResizeListener = null;
        this.windowMenuBarResizeListener = null;
        this.window = null;
    }

    private void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = new SyntheticaRootLayout();
        }
        this.oldLayoutManager = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.oldLayoutManager != null) {
            root.setLayout(this.oldLayoutManager);
        }
        this.oldLayoutManager = null;
        this.layoutManager = null;
    }

    private void setTitlePane(JRootPane root, JComponent titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        if (this.titlePane != null) {
            this.titlePane.setVisible(false);
            layeredPane.remove(this.titlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    public void propertyChange(PropertyChangeEvent e2) {
        super.propertyChange(e2);
        String propertyName = e2.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            this.uninstallClientDecorations(this.rootPane);
            if (this.isDecorated(this.rootPane)) {
                this.installClientDecorations(this.rootPane);
            }
        } else if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners(this.rootPane);
            if (this.isDecorated(this.rootPane)) {
                this.installWindowListeners(this.rootPane, this.rootPane.getParent());
            }
        } else if (propertyName.equals("Synthetica.style") && this.titlePane instanceof SyntheticaTitlePane) {
            ((SyntheticaTitlePane)this.titlePane).updateLayoutStyle();
        }
    }

    public void setMaximizedBounds(Frame frame) {
        if (SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.fullscreen")) {
            return;
        }
        GraphicsConfiguration gc = frame.getGraphicsConfiguration();
        Rectangle screenBounds = gc.getBounds();
        if (!SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.respectScreenBoundsX")) {
            screenBounds.x = 0;
        }
        if (!SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.respectScreenBoundsY")) {
            screenBounds.y = 0;
        }
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        if (SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.ignoreScreenInsets")) {
            frame.setMaximizedBounds(screenBounds);
            return;
        }
        if (!SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.disableAutoHideTaskBarCorrection") && screenInsets.bottom == 0) {
            ++screenInsets.bottom;
        }
        Rectangle maxBounds = new Rectangle(screenBounds.x + screenInsets.left, screenBounds.y + screenInsets.top, screenBounds.width - (screenInsets.left + screenInsets.right), screenBounds.height - (screenInsets.top + screenInsets.bottom));
        frame.setMaximizedBounds(maxBounds);
    }

    private boolean isDecorated(JRootPane root) {
        return root.getWindowDecorationStyle() != 0;
    }

    public MouseInputListener getMouseInputListener() {
        return this.mouseInputListener;
    }

    public void setMouseInputListener(MouseInputListener listener) {
        if (this.mouseInputListener != null && this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
        this.mouseInputListener = listener;
        if (this.mouseInputListener != null && this.window != null) {
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private static final int WINDOW_MOVE = 1;
        private static final int WINDOW_RESIZE = 2;
        private int windowAction;
        private int dragXOffset;
        private int dragYOffset;
        private Dimension dragDimension;
        private int resizeType;
        private int minimumYPos;
        private int maximumYPos;
        private boolean liveResize;
        private boolean liveDrag;
        private Rectangle resizeBounds;
        private JWindow dragResizeWindow;
        private final PrivilegedExceptionAction<?> locationAction;
        private Frame frame;
        private Dialog dialog;

        private MouseInputHandler() {
            this.liveResize = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.liveResizeEnabled", SyntheticaRootPaneUI.this.window, true);
            this.liveDrag = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.liveDragEnabled", SyntheticaRootPaneUI.this.window, true);
            this.locationAction = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws HeadlessException {
                    return MouseInfo.getPointerInfo().getLocation();
                }
            };
            this.frame = null;
            this.dialog = null;
            if (SyntheticaRootPaneUI.this.window instanceof Frame) {
                this.frame = (Frame)SyntheticaRootPaneUI.this.window;
            } else if (SyntheticaRootPaneUI.this.window instanceof Dialog) {
                this.dialog = (Dialog)SyntheticaRootPaneUI.this.window;
            }
        }

        private Point getPoint(MouseEvent evt) {
            return SwingUtilities.convertPoint(evt.getComponent(), evt.getPoint(), SyntheticaRootPaneUI.this.window);
        }

        public void mousePressed(MouseEvent evt) {
            if (!SyntheticaRootPaneUI.this.isDecorated(SyntheticaRootPaneUI.this.rootPane)) {
                return;
            }
            SyntheticaRootPaneUI.this.window.toFront();
            Rectangle bounds = SyntheticaRootPaneUI.this.window.getGraphicsConfiguration().getBounds();
            this.minimumYPos = bounds.y;
            this.maximumYPos = bounds.y + bounds.height;
            Point windowPoint = this.getPoint(evt);
            Point titlePanePoint = SwingUtilities.convertPoint(SyntheticaRootPaneUI.this.window, windowPoint, SyntheticaRootPaneUI.this.titlePane);
            int cursor = this.position2Cursor(SyntheticaRootPaneUI.this.window, windowPoint.x, windowPoint.y);
            if (cursor == 0 && SyntheticaRootPaneUI.this.titlePane != null && SyntheticaRootPaneUI.this.titlePane.contains(titlePanePoint) && (this.dialog != null || this.frame != null && this.frame.getExtendedState() != 6)) {
                this.windowAction = 1;
                this.dragXOffset = windowPoint.x;
                this.dragYOffset = windowPoint.y;
                if (!this.liveDrag && this.dragResizeWindow == null) {
                    this.dragResizeWindow = this.createDragResizeWindow();
                    this.dragResizeWindow.setBounds(SyntheticaRootPaneUI.this.window.getBounds());
                    this.dragResizeWindow.setVisible(true);
                }
            } else if (this.isWindowResizable()) {
                this.windowAction = 2;
                this.dragXOffset = windowPoint.x;
                this.dragYOffset = windowPoint.y;
                this.dragDimension = new Dimension(SyntheticaRootPaneUI.this.window.getWidth(), SyntheticaRootPaneUI.this.window.getHeight());
                this.resizeType = this.position2Cursor(SyntheticaRootPaneUI.this.window, windowPoint.x, windowPoint.y);
                if (!this.liveResize && this.resizeType != 0 && this.dragResizeWindow == null) {
                    this.dragResizeWindow = this.createDragResizeWindow();
                    this.dragResizeWindow.setCursor(Cursor.getPredefinedCursor(cursor));
                    this.dragResizeWindow.setBounds(SyntheticaRootPaneUI.this.window.getBounds());
                    this.dragResizeWindow.setVisible(true);
                }
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (this.dragResizeWindow != null && (this.windowAction == 2 && !this.liveResize || this.windowAction == 1 && !this.liveDrag)) {
                Rectangle bounds = this.dragResizeWindow.getBounds();
                this.dragResizeWindow.setVisible(false);
                this.dragResizeWindow.dispose();
                if (this.windowAction == 2 && this.resizeBounds != null) {
                    SyntheticaRootPaneUI.this.window.setBounds(this.resizeBounds);
                } else {
                    SyntheticaRootPaneUI.this.window.setBounds(bounds);
                }
                this.dragResizeWindow = null;
                this.resizeBounds = null;
            }
            if (this.windowAction == 2 && !SyntheticaRootPaneUI.this.window.isValid()) {
                SyntheticaRootPaneUI.this.window.validate();
                SyntheticaRootPaneUI.this.rootPane.repaint();
            }
            this.windowAction = -1;
            SyntheticaRootPaneUI.this.window.setCursor(Cursor.getDefaultCursor());
        }

        private void cancelDragResize() {
            if (this.dragResizeWindow != null && (this.windowAction == 2 && !this.liveResize || this.windowAction == 1 && !this.liveDrag)) {
                this.dragResizeWindow.setVisible(false);
                this.dragResizeWindow.dispose();
                this.dragResizeWindow = null;
                this.resizeBounds = null;
            }
        }

        public void mouseMoved(MouseEvent evt) {
            if (!SyntheticaRootPaneUI.this.isDecorated(SyntheticaRootPaneUI.this.rootPane)) {
                return;
            }
            Point p = this.getPoint(evt);
            int cursor = this.position2Cursor(SyntheticaRootPaneUI.this.window, p.x, p.y);
            if (cursor != 0 && this.isWindowResizable()) {
                SyntheticaRootPaneUI.this.window.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                SyntheticaRootPaneUI.this.window.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mouseEntered(MouseEvent evt) {
            this.mouseMoved(evt);
        }

        public void mouseExited(MouseEvent evt) {
            SyntheticaRootPaneUI.this.window.setCursor(Cursor.getDefaultCursor());
        }

        public void mouseDragged(MouseEvent evt) {
            block19: {
                GraphicsConfiguration gc = SyntheticaRootPaneUI.this.window.getGraphicsConfiguration();
                Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
                this.minimumYPos = gc.getBounds().y + screenInsets.top;
                this.maximumYPos = gc.getBounds().y + gc.getBounds().height - screenInsets.bottom - SyntheticaRootPaneUI.this.titlePane.getHeight() - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).rootPane.getInsets().top;
                boolean respectMinimumYPos = SyntheticaLookAndFeel.isSystemPropertySet("synthetica.window.respectMinimumYPos");
                boolean respectMaximumYPos = SyntheticaLookAndFeel.isSystemPropertySet("synthetica.window.respectMaximumYPos");
                if (this.windowAction == 1) {
                    try {
                        Point p = (Point)AccessController.doPrivileged(this.locationAction);
                        p.x -= this.dragXOffset;
                        p.y -= this.dragYOffset;
                        if (respectMinimumYPos && p.y < this.minimumYPos) {
                            p.y = this.minimumYPos;
                        }
                        if (respectMaximumYPos && p.y > this.maximumYPos) {
                            p.y = this.maximumYPos;
                        }
                        if (this.liveDrag) {
                            SyntheticaRootPaneUI.this.window.setLocation(p);
                            break block19;
                        }
                        this.dragResizeWindow.setLocation(p);
                    }
                    catch (PrivilegedActionException e2) {}
                } else if (this.windowAction == 2) {
                    Point pt = this.getPoint(evt);
                    Dimension min = (Dimension)SyntheticaLookAndFeel.get("Synthetica.rootPane.minimumWindowSize", SyntheticaRootPaneUI.this.window);
                    if (min == null) {
                        min = SyntheticaRootPaneUI.this.window.getMinimumSize();
                    }
                    this.resizeBounds = SyntheticaRootPaneUI.this.window.getBounds();
                    Rectangle startBounds = new Rectangle(this.resizeBounds);
                    if (this.resizeType == 11 || this.resizeType == 7 || this.resizeType == 5) {
                        this.resizeBounds.width = Math.max(min.width, this.dragDimension.width + pt.x - this.dragXOffset);
                    }
                    if (this.resizeType == 9 || this.resizeType == 4 || this.resizeType == 5) {
                        this.resizeBounds.height = Math.max(min.height, this.dragDimension.height + pt.y - this.dragYOffset);
                    }
                    if (this.resizeType == 8 || this.resizeType == 6 || this.resizeType == 7) {
                        int dy = pt.y - this.dragYOffset;
                        this.resizeBounds.y += dy;
                        this.resizeBounds.height -= dy;
                        if (this.resizeBounds.height < min.height) {
                            this.resizeBounds.y += this.resizeBounds.height - min.height;
                            this.resizeBounds.height = min.height;
                        }
                    }
                    if (this.resizeType == 10 || this.resizeType == 6 || this.resizeType == 4) {
                        int dx = pt.x - this.dragXOffset;
                        this.resizeBounds.x += dx;
                        this.resizeBounds.width -= dx;
                        if (this.resizeBounds.width < min.width) {
                            this.resizeBounds.x += this.resizeBounds.width - min.width;
                            this.resizeBounds.width = min.width;
                        }
                    }
                    if (respectMinimumYPos && this.resizeBounds.y < this.minimumYPos) {
                        this.resizeBounds.y = this.minimumYPos;
                    }
                    if (!this.resizeBounds.equals(startBounds)) {
                        if (this.liveResize) {
                            SyntheticaRootPaneUI.this.window.setBounds(this.resizeBounds);
                        } else {
                            this.dragResizeWindow.setBounds(this.resizeBounds);
                        }
                    }
                }
            }
        }

        public void mouseClicked(MouseEvent evt) {
            if (this.frame == null) {
                return;
            }
            Point convertedPoint = SwingUtilities.convertPoint(SyntheticaRootPaneUI.this.window, this.getPoint(evt), SyntheticaRootPaneUI.this.titlePane);
            if (SyntheticaRootPaneUI.this.titlePane != null && SyntheticaRootPaneUI.this.titlePane.contains(convertedPoint) && evt.getClickCount() == 2 && (evt.getModifiers() & 0x10) == 16) {
                if (this.frame.isResizable() && this.isFrameResizable()) {
                    ((SyntheticaTitlePane)SyntheticaRootPaneUI.this.titlePane).maximize();
                } else if (this.frame.isResizable() && !this.isFrameResizable()) {
                    ((SyntheticaTitlePane)SyntheticaRootPaneUI.this.titlePane).restore();
                }
            }
        }

        private int position2Cursor(Window w, int x, int y) {
            int ww = w.getWidth();
            int wh = w.getHeight();
            if (x < ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.left && y < ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.top) {
                return 6;
            }
            if (x > ww - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.right && y < ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.top) {
                return 7;
            }
            if (x < ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.left && y > wh - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.bottom) {
                return 4;
            }
            if (x > ww - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.right && y > wh - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.bottom) {
                return 5;
            }
            if (x < ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.left) {
                return 10;
            }
            if (x > ww - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.right) {
                return 11;
            }
            if (y < ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.top) {
                return 8;
            }
            if (y > wh - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.bottom) {
                return 9;
            }
            return 0;
        }

        private JWindow createDragResizeWindow() {
            JWindow w = new JWindow(SyntheticaRootPaneUI.this.window);
            w.getRootPane().setContentPane(new JComponent(){

                public void paintComponent(Graphics g2) {
                    super.paintComponents(g2);
                    MouseInputHandler.this.paintResizeBackground(SyntheticaRootPaneUI.this.rootPane, g2, 0, 0, this.getWidth(), this.getHeight());
                }
            });
            SyntheticaLookAndFeel.setWindowOpaque(w, false);
            return w;
        }

        private void paintResizeBackground(JRootPane rootPane, Graphics g2, int x, int y, int w, int h2) {
            RootPanePainter.getInstance().paintResizeBackground(rootPane, null, g2, x, y, w, h2);
        }

        private boolean isFrameResizable() {
            return this.frame != null && this.frame.isResizable() && (this.frame.getExtendedState() & 6) == 0;
        }

        private boolean isDialogResizable() {
            return this.dialog != null && this.dialog.isResizable();
        }

        private boolean isWindowResizable() {
            return this.isFrameResizable() || this.isDialogResizable();
        }
    }

    private static class SyntheticaRootLayout
    implements LayoutManager2 {
        private SyntheticaRootLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            JComponent titlePane = ((SyntheticaRootPaneUI)root.getUI()).titlePane;
            Dimension dimC = new Dimension(0, 0);
            dimC = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            dimC = dimC == null ? new Dimension(0, 0) : dimC;
            Dimension dimM = new Dimension(0, 0);
            if (root.getJMenuBar() != null) {
                dimM = root.getJMenuBar().getPreferredSize();
            }
            dimM = dimM == null ? new Dimension(0, 0) : dimM;
            Dimension dimT = titlePane.getPreferredSize();
            dimT = dimT == null ? new Dimension(0, 0) : dimT;
            int width = Math.max(dimC.width, Math.max(dimM.width, dimT.width)) + insets.left + insets.right;
            int height = dimC.height + dimM.height + dimT.height + insets.top + insets.bottom;
            return new Dimension(width, height);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            JComponent titlePane = ((SyntheticaRootPaneUI)root.getUI()).titlePane;
            Dimension dimC = new Dimension(0, 0);
            dimC = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            dimC = dimC == null ? new Dimension(0, 0) : dimC;
            Dimension dimM = new Dimension(0, 0);
            if (root.getJMenuBar() != null) {
                dimM = root.getJMenuBar().getMinimumSize();
            }
            dimM = dimM == null ? new Dimension(0, 0) : dimM;
            Dimension dimT = titlePane.getMinimumSize();
            dimT = dimT == null ? new Dimension(0, 0) : dimT;
            int width = Math.max(dimC.width, Math.max(dimM.width, dimT.width)) + insets.left + insets.right;
            int height = dimC.height + dimM.height + dimT.height + insets.top + insets.bottom;
            return new Dimension(width, height);
        }

        public Dimension maximumLayoutSize(Container target) {
            int height;
            Insets insets = target.getInsets();
            JRootPane root = (JRootPane)target;
            JComponent titlePane = ((SyntheticaRootPaneUI)root.getUI()).titlePane;
            Dimension dimC = new Dimension(0, 0);
            dimC = root.getContentPane() != null ? root.getContentPane().getMaximumSize() : root.getSize();
            dimC = dimC == null ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : dimC;
            Dimension dimM = new Dimension(0, 0);
            if (root.getJMenuBar() != null) {
                dimM = root.getJMenuBar().getMaximumSize();
            }
            dimM = dimM == null ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : dimM;
            Dimension dimT = titlePane.getMaximumSize();
            dimT = dimT == null ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : dimT;
            int width = Math.max(dimC.width, Math.max(dimM.width, dimT.width));
            if (width != Integer.MAX_VALUE) {
                width += insets.left + insets.right;
            }
            if ((height = Math.max(dimC.height, Math.max(dimM.height, dimT.height))) != Integer.MAX_VALUE) {
                height += insets.top + insets.bottom;
            }
            return new Dimension(width, height);
        }

        public void layoutContainer(Container parent) {
            Container cPane;
            JMenuBar mBar;
            JRootPane rootPane = (JRootPane)parent;
            Rectangle bounds = rootPane.getBounds();
            Insets insets = rootPane.getInsets() != null ? rootPane.getInsets() : new Insets(0, 0, 0, 0);
            int width = bounds.width - insets.right - insets.left;
            int height = bounds.height - insets.top - insets.bottom;
            int nextY = 0;
            if (rootPane.getLayeredPane() != null) {
                rootPane.getLayeredPane().setBounds(insets.left, insets.top, width, height);
            }
            if (rootPane.getGlassPane() != null) {
                rootPane.getGlassPane().setBounds(insets.left, insets.top, width, height);
            }
            JComponent titlePane = ((SyntheticaRootPaneUI)rootPane.getUI()).titlePane;
            Dimension dimT = null;
            if (titlePane.isEnabled() && (dimT = titlePane.getPreferredSize()) != null) {
                titlePane.setBounds(0, 0, width, dimT.height);
                nextY += dimT.height;
            }
            if ((mBar = rootPane.getJMenuBar()) != null && titlePane instanceof SyntheticaTitlePane) {
                SyntheticaTitlePane titlePane_ = (SyntheticaTitlePane)titlePane;
                Dimension dimM = mBar.getPreferredSize();
                if (titlePane_.showMenuBarInTitlePane()) {
                    int mBarX;
                    boolean ltr = mBar.getComponentOrientation().isLeftToRight();
                    JComponent mb = (JComponent)SyntheticaLookAndFeel.findComponent("RootPane.menuBar", (Container)titlePane);
                    Insets mbInsets = mb.getInsets();
                    nextY = mb.getY() + mbInsets.top;
                    int n2 = titlePane_.clipMenuBarWidth() ? mb.getX() : (mBarX = ltr ? mb.getX() : 0);
                    int mBarWidth = titlePane_.clipMenuBarWidth() ? mb.getWidth() - mbInsets.left - mbInsets.right : (ltr ? width - mb.getX() : mb.getX() + mb.getWidth());
                    mBar.setBounds(mBarX + mbInsets.left, nextY, mBarWidth, dimM.height);
                    nextY += mbInsets.top + mbInsets.bottom + dimM.height;
                    JComponent userComponent = titlePane_.getUserComponent();
                    if (userComponent != null && titlePane_.getLayoutStyle() == SyntheticaTitlePane.LayoutStyle.SECONDARYMENU) {
                        nextY += userComponent.getPreferredSize().height;
                    }
                    nextY = Math.max(nextY, dimT == null ? 0 : dimT.height);
                } else {
                    mBar.setBounds(0, nextY, width, dimM.height);
                    nextY += dimM.height;
                }
            }
            if ((cPane = rootPane.getContentPane()) != null) {
                cPane.setBounds(0, nextY, width, height < nextY ? 0 : height - nextY);
            }
        }
    }
}

